/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.problem.KeyValuePairing;
import com.ibm.hwmca.xfw.pa.problem.ProblemBeanFactory;
import com.ibm.hwmca.xfw.panel.CaptionValuePairing;
import com.ibm.hwmca.xfw.panel.NonLocalizablePanelValue;
import com.ibm.hwmca.xfw.panel.pa.TypeEightCommonBean;
import com.ibm.hwmca.xfw.panel.pa.TypeNineCommonBean;
import com.ibm.hwmca.xfw.panel.pa.primary.DetailsBean;
import com.ibm.hwmca.xfw.panel.pa.primary.ManualCallHomeBean;
import com.ibm.hwmca.xfw.panel.pa.primary.PAPanelBean;
import com.ibm.hwmca.xfw.panel.pa.primary.PECEBean;
import com.ibm.hwmca.xfw.panel.pa.rsffail.RSFFailBean;
import com.ibm.hwmca.xfw.panel.pa.rsfok.RSFOkBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.ProblemSummaryBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.RepairInformationBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.ServiceInformationAdminBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.ServiceInformationOperatorBean;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class CommonBeanFactory
implements ProblemBeanFactory {
    private static final String TRACE_MASKT = "XPACBF T";
    private static final String TRACE_MASKF = "XPACBF F";
    private static final String TRACE_MASKD = "XPACBF D";
    private static final boolean UNIT_TEST = false;

    public PanelBean getProblemAnalysisBean(CommonProblem problem, ObjectId objectId, String system, int mode) {
        Trace.trace(TRACE_MASKD, "--> getProblemAnalysisBean()");
        com.ibm.hwmca.xfw.panel.pa.PAPanelBean theBean = null;
        theBean = mode == 1 ? new PAPanelBean() : new com.ibm.hwmca.xfw.panel.pa.svchist.PAPanelBean();
        DateFormat df = null;
        DateFormat tf = null;
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            df = DateFormat.getDateInstance(2, userContext.getLocale());
            df.setTimeZone(userContext.getTimeZone());
            tf = DateFormat.getTimeInstance(2, userContext.getLocale());
            tf.setTimeZone(userContext.getTimeZone());
        }
        catch (NullContextException e) {
            df = DateFormat.getDateInstance();
            tf = DateFormat.getTimeInstance();
        }
        Date problemDate = new Date(problem.getProblemTimeStamp());
        Trace.trace(TRACE_MASKD, "set up the system name, date and time");
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1900"), new NonLocalizablePanelValue(system)));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1901"), new NonLocalizablePanelValue(df.format(problemDate))));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1902"), new NonLocalizablePanelValue(tf.format(problemDate))));
        KeyValuePairing kvp = problem.getAnalysisData().getSummary();
        Iterator adIt = kvp.keyIterator();
        while (adIt.hasNext()) {
            Trace.trace(TRACE_MASKD, "got a key");
            CaptionValuePairing cvp = (CaptionValuePairing)kvp.get(adIt.next());
            Trace.trace(TRACE_MASKD, "cvp caption key = " + cvp.getCaption().getKey());
            Trace.trace(TRACE_MASKD, "cvp caption = " + cvp.getCaption());
            Trace.trace(TRACE_MASKD, "cvp value = " + cvp.getValue());
            theBean.addProblemData(cvp);
        }
        Trace.trace(TRACE_MASKD, "fill in the actions section");
        if (problem.hasSenseData() && theBean instanceof PAPanelBean) {
            Trace.trace(TRACE_MASKD, "this problem has sense data.");
            ((PAPanelBean)theBean).setHasSense(true);
        }
        theBean.setProblemDescription(CommonBeanFactory.getLtArray(problem.getAnalysisData().getProblemStatement()));
        theBean.setCorrectiveAction(CommonBeanFactory.getLtArray(problem.getAnalysisData().getProblemCorrectiveAction()));
        theBean.setRepairImpact(CommonBeanFactory.getLtArray(problem.getAnalysisData().getProblemRepairImpact()));
        Trace.trace(TRACE_MASKD, "<-- getProblemAnalysisBean()");
        return theBean;
    }

    public PanelBean getServiceInformationBeanCE(CommonProblem problem, ObjectId objectId, String system, int mode) {
        TypeNineCommonBean theBean = null;
        theBean = mode == 1 ? new PECEBean() : new ServiceInformationAdminBean();
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1903"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineType())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1904"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineModel())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1905"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineSerial())));
        String sProbNumber = "Critical Problem";
        int iProbNum = problem.getProblemNumber();
        if (iProbNum != Integer.MIN_VALUE) {
            sProbNumber = new Integer(problem.getProblemNumber()).toString();
        }
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1907"), new NonLocalizablePanelValue(sProbNumber)));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1913"), new NonLocalizablePanelValue(problem.getRefcode())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA19100"), new NonLocalizablePanelValue(problem.getExtension())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA19101"), new NonLocalizablePanelValue(problem.getStatus())));
        String problemString = problem.getProblemDataString();
        if (problemString != null) {
            theBean.setProblemDescription(new LocalizableText(problem.getProblemDataString()));
        } else {
            theBean.setProblemDescription(new BaseMessageText("XPA1910"));
        }
        List partList = problem.getParts();
        if (partList != null) {
            int partCount = partList.size();
            Iterator listIt = partList.iterator();
            while (listIt.hasNext()) {
                CommonPaFru aFru = (CommonPaFru)listIt.next();
                theBean.addPart(aFru.getLocation(), aFru.getPartNumber(), aFru.getPercent(), aFru.getSerialNumber());
            }
        }
        return theBean;
    }

    public PanelBean getServiceInformationBeanOperator(CommonProblem problem, ObjectId objectId, String system, int mode) {
        TypeEightCommonBean theBean = null;
        theBean = mode == 1 ? new ManualCallHomeBean() : new ServiceInformationOperatorBean();
        theBean.setSeviceCallOutput(problem.getServicePhoneNumber());
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1903"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineType())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1904"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineModel())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1905"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineSerial())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1908"), new NonLocalizablePanelValue(problem.getProblemType())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1907"), new NonLocalizablePanelValue(new Integer(problem.getProblemNumber()).toString())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1909"), new NonLocalizablePanelValue(problem.getProblemDataString())));
        theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1912"), new NonLocalizablePanelValue(problem.getRefcode() + "-" + problem.getExtension())));
        return theBean;
    }

    public ProblemSummaryBean getProblemSummaryBean(CommonProblem problem, ObjectId objectId, String system) {
        ProblemSummaryBean psb = new ProblemSummaryBean();
        psb.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1900"), new NonLocalizablePanelValue(system)));
        psb.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1903"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineType())));
        psb.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1904"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineModel())));
        psb.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1905"), new NonLocalizablePanelValue(problem.getFailingSystem().getMachineSerial())));
        psb.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1906"), new NonLocalizablePanelValue(problem.getPMH())));
        psb.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1907"), new NonLocalizablePanelValue(new Integer(problem.getProblemNumber()).toString())));
        psb.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1908"), new NonLocalizablePanelValue(problem.getProblemType())));
        psb.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1909"), new NonLocalizablePanelValue(problem.getProblemDataString())));
        Iterator histIt = problem.getServiceHistory().getHistory().iterator();
        while (histIt.hasNext()) {
            HistoryEntry entry = (HistoryEntry)histIt.next();
            int state = entry.getHistory();
            Trace.trace(TRACE_MASKD, "add state =" + state);
            psb.addServiceHistoryData(entry.getDate(), new BaseMessageText(CommonBeanFactory.getServiceHistoryMessageId(state)));
        }
        return psb;
    }

    public RepairInformationBean getRepairInformationBean(CommonProblem problem, ObjectId objectId, String system) {
        String fixDesc;
        Trace.trace(TRACE_MASKF, "--> getRepairInformationBean");
        RepairInformationBean rib = null;
        List partList = problem.getReplacedParts();
        if (partList != null) {
            Trace.trace(TRACE_MASKF, "got a parts list to work with");
            rib = new RepairInformationBean();
            int partCount = partList.size();
            Iterator listIt = partList.iterator();
            while (listIt.hasNext()) {
                CommonPaFru aFru = (CommonPaFru)listIt.next();
                rib.addReplacedPart(aFru.getLocation(), aFru.getPartNumber(), aFru.getSerialNumber());
            }
            Trace.trace(TRACE_MASKD, "add the fix description");
        }
        if ((fixDesc = problem.getFixDescription()) != null) {
            if (rib == null) {
                rib = new RepairInformationBean();
            }
            rib.setFixDescription(new LocalizableText(fixDesc));
        }
        return rib;
    }

    public PanelBean getRSFOkBean(CommonProblem problem, ObjectId objectId, String system, int mode) {
        RSFOkBean theBean = new RSFOkBean();
        if (problem != null) {
            DateFormat df = null;
            DateFormat tf = null;
            try {
                ClientUserContext userContext = ClientUserContext.getUserContext();
                df = DateFormat.getDateInstance(2, userContext.getLocale());
                df.setTimeZone(userContext.getTimeZone());
                tf = DateFormat.getTimeInstance(2, userContext.getLocale());
                tf.setTimeZone(userContext.getTimeZone());
            }
            catch (NullContextException e) {
                df = DateFormat.getDateInstance();
                tf = DateFormat.getTimeInstance();
            }
            Date problemDate = new Date(problem.getProblemTimeStamp());
            Trace.trace(TRACE_MASKD, "set up the system name, date and time");
            theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1900"), new NonLocalizablePanelValue(system)));
            theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1901"), new NonLocalizablePanelValue(df.format(problemDate))));
            theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1902"), new NonLocalizablePanelValue(tf.format(problemDate))));
            Object[] subString = new String[]{new Integer(problem.getProblemNumber()).toString(), problem.getPMH()};
            theBean.setMessage(new BaseMessageText("XPA9105", subString));
        }
        return theBean;
    }

    public PanelBean getRSFFailureBean(CommonProblem problem, ObjectId objectId, String system, int mode) {
        RSFFailBean theBean = new RSFFailBean();
        if (problem != null) {
            DateFormat df = null;
            DateFormat tf = null;
            try {
                ClientUserContext userContext = ClientUserContext.getUserContext();
                df = DateFormat.getDateInstance(2, userContext.getLocale());
                df.setTimeZone(userContext.getTimeZone());
                tf = DateFormat.getTimeInstance(2, userContext.getLocale());
                tf.setTimeZone(userContext.getTimeZone());
            }
            catch (NullContextException e) {
                df = DateFormat.getDateInstance();
                tf = DateFormat.getTimeInstance();
            }
            Date problemDate = new Date(problem.getProblemTimeStamp());
            Trace.trace(TRACE_MASKD, "set up the system name, date and time");
            theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1900"), new NonLocalizablePanelValue(system)));
            theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1901"), new NonLocalizablePanelValue(df.format(problemDate))));
            theBean.addProblemData(new CaptionValuePairing(new BaseMessageText("XPA1902"), new NonLocalizablePanelValue(tf.format(problemDate))));
            theBean.setProblemDescription(new BaseMessageText("XPA9101"));
        }
        return theBean;
    }

    public PanelBean getDetailsBean(CommonProblem problem, ObjectId objectId, String system, int mode) {
        CaptionValuePairing[] entries = null;
        entries = problem.hasSenseData() ? CommonBeanFactory.formatSenseData(problem) : new CaptionValuePairing[]{new CaptionValuePairing(new LocalizableText("No additional details available"), new NonLocalizablePanelValue(""))};
        DetailsBean theBean = new DetailsBean(entries);
        return theBean;
    }

    public static String getServiceHistoryMessageId(int state) {
        switch (state) {
            case 1: {
                Trace.trace(TRACE_MASKD, "XSH_OPEN");
                return "XSH343";
            }
            case 11: {
                Trace.trace(TRACE_MASKD, "XSH_REOPENED");
                return "XSH344";
            }
            case 2: {
                Trace.trace(TRACE_MASKD, "XSH_CUSTOMER_REPORT");
                return "XSH345";
            }
            case 13: {
                Trace.trace(TRACE_MASKD, "XSH_SERV_AUTH_VIA_RSF");
                return "XSH1367";
            }
            case 14: {
                Trace.trace(TRACE_MASKD, "XSH_SERV_AUTH_DELAYED");
                return "XSH1368";
            }
            case 15: {
                Trace.trace(TRACE_MASKD, "XSH_SERV_AUTH_VIA_PHONE");
                return "XSH1369";
            }
            case 16: {
                Trace.trace(TRACE_MASKD, "XSH_SERV_NOT_REQUESTED");
                return "XSH1370";
            }
            case 3: {
                Trace.trace(TRACE_MASKD, "XSH_SERVICE_REPORT");
                return "XSH1371";
            }
            case 17: {
                Trace.trace(TRACE_MASKD, "XSH_SERV_AUTH_FAILED");
                return "XSH1372";
            }
            case 18: {
                Trace.trace(TRACE_MASKD, "XSH_SERV_REQ_CANCELLED");
                return "XSH954";
            }
            case 19: {
                Trace.trace(TRACE_MASKD, "XSH_REPAIR_CANCELLED");
                return "XSH1924";
            }
            case 4: {
                Trace.trace(TRACE_MASKD, "XSH_REPAIR_STARTED");
                return "XSH347";
            }
            case 12: {
                Trace.trace(TRACE_MASKD, "XSH_NEW_PROBLEM_DATA");
                return "XSH531";
            }
            case 5: {
                Trace.trace(TRACE_MASKD, "XSH_REPAIR_SUSPENDED");
                return "XSH348";
            }
            case 6: {
                Trace.trace(TRACE_MASKD, "XSH_REPAIR_TO_HARDCOPY");
                return "XSH349";
            }
            case 7: {
                Trace.trace(TRACE_MASKD, "XSH_REPAIR_FROM_HARDCOPY");
                return "XSH350";
            }
            case 8: {
                Trace.trace(TRACE_MASKD, "XSH_REPAIR_RESUMED");
                return "XSH351";
            }
            case 9: {
                Trace.trace(TRACE_MASKD, "XSH_REPAIR_ENDED");
                return "XSH352";
            }
            case 32: {
                Trace.trace(TRACE_MASKD, "XSH_CLOSED");
                return "XSH353";
            }
            case 33: {
                Trace.trace(TRACE_MASKD, "XSH_CLOSED_BY_USER");
                return "XSH1402";
            }
            case 34: {
                Trace.trace(TRACE_MASKD, "XSH_INACTIVE_PROB_CLOSED");
                return "XSH1403";
            }
            case 35: {
                Trace.trace(TRACE_MASKD, "XSH_DUP_PROBLEM_CLOSED");
                return "XSH1373";
            }
            case 36: {
                Trace.trace(TRACE_MASKD, "XSH_CLOSED_NON_REPAIR");
                return "XSH1987";
            }
            case 20: {
                Trace.trace(TRACE_MASKD, "XSH_NO_MSG_DISPLAYED");
                return "XSH1374";
            }
            case 21: {
                Trace.trace(TRACE_MASKD, "XSH_NO_FIX_AVAIL");
                return "XSH1375";
            }
            case 22: {
                Trace.trace(TRACE_MASKD, "XSH_FIX_AVAIL_EXPECT_CALL");
                return "XSH1376";
            }
            case 23: {
                Trace.trace(TRACE_MASKD, "XSH_FIX_AVAIL_CUST_CALL");
                return "XSH1377";
            }
        }
        Trace.trace(TRACE_MASKD, "could find the message");
        return "XSH2213";
    }

    protected static LocalizableText[] getLtArray(List list) {
        int length = list.size();
        LocalizableText[] ltArray = new LocalizableText[length];
        for (int i = 0; i < length; ++i) {
            ltArray[i] = (LocalizableText)list.get(i);
        }
        return ltArray;
    }

    private static CaptionValuePairing[] formatSenseData(CommonProblem problem) {
        CaptionValuePairing[] entries = null;
        String senseDataString = problem.getSenseData();
        byte[] senseData = senseDataString.getBytes();
        entries = senseData[15] == 1 ? new CaptionValuePairing[]{new CaptionValuePairing(new BaseMessageText("XPA16000"), new NonLocalizablePanelValue(new String(senseData, 0, 4))), new CaptionValuePairing(new BaseMessageText("XPA16001"), new NonLocalizablePanelValue(new String(senseData, 4, 4))), new CaptionValuePairing(new BaseMessageText("XPA16002"), new NonLocalizablePanelValue(new String(senseData, 8, 4))), new CaptionValuePairing(new BaseMessageText("XPA16003"), new NonLocalizablePanelValue(new String(senseData, 12, 4))), new CaptionValuePairing(new BaseMessageText("XPA16004"), new NonLocalizablePanelValue(new String(senseData, 16, 4))), new CaptionValuePairing(new BaseMessageText("XPA16005"), new NonLocalizablePanelValue(new String(senseData, 20, 4))), new CaptionValuePairing(new BaseMessageText("XPA16006"), new NonLocalizablePanelValue(new String(senseData, 24, 4))), new CaptionValuePairing(new BaseMessageText("XPA16007"), new NonLocalizablePanelValue(new String(senseData, 28, 4)))} : ((senseData[27] & 0xFFFFFF80) != 0 ? new CaptionValuePairing[]{new CaptionValuePairing(new BaseMessageText("XPA16008"), new NonLocalizablePanelValue(CommonBeanFactory.formatByte0(senseData[0]))), new CaptionValuePairing(new BaseMessageText("XPA16009"), new NonLocalizablePanelValue(CommonBeanFactory.formatByte1(senseData[1]))), new CaptionValuePairing(new BaseMessageText("XPA16010"), new NonLocalizablePanelValue(CommonBeanFactory.formatByte2(senseData[2]))), new CaptionValuePairing(new BaseMessageText("XPA16011"), new NonLocalizablePanelValue(new String(senseData, 3, 1))), new CaptionValuePairing(new BaseMessageText("XPA16013"), new NonLocalizablePanelValue(new String(senseData, 4, 1))), new CaptionValuePairing(new BaseMessageText("XPA16015"), new NonLocalizablePanelValue(new String(senseData, 5, 1))), new CaptionValuePairing(new BaseMessageText("XPA16017"), new NonLocalizablePanelValue(new String(senseData, 6, 1))), new CaptionValuePairing(new BaseMessageText("XPA16019"), new NonLocalizablePanelValue(new String(senseData, 7, 1))), new CaptionValuePairing(new BaseMessageText("XPA16020"), new NonLocalizablePanelValue(new String(senseData, 8, 16))), new CaptionValuePairing(new BaseMessageText("XPA16021"), new NonLocalizablePanelValue(new String(senseData, 24, 1))), new CaptionValuePairing(new BaseMessageText("XPA16026"), new NonLocalizablePanelValue(new String(senseData, 25, 1))), new CaptionValuePairing(new BaseMessageText("XPA16027"), new NonLocalizablePanelValue(new String(senseData, 26, 2))), new CaptionValuePairing(new BaseMessageText("XPA16021"), new NonLocalizablePanelValue(new String(senseData, 28, 1))), new CaptionValuePairing(new BaseMessageText("XPA16028"), new NonLocalizablePanelValue(new String(senseData, 29, 3)))} : new CaptionValuePairing[]{new CaptionValuePairing(new BaseMessageText("XPA16008"), new NonLocalizablePanelValue(CommonBeanFactory.formatByte0(senseData[0]))), new CaptionValuePairing(new BaseMessageText("XPA16009"), new NonLocalizablePanelValue(CommonBeanFactory.formatByte1(senseData[1]))), new CaptionValuePairing(new BaseMessageText("XPA16010"), new NonLocalizablePanelValue(new String(senseData, 2, 1))), new CaptionValuePairing(new BaseMessageText("XPA16012"), new NonLocalizablePanelValue(new String(senseData, 3, 1))), new CaptionValuePairing(new BaseMessageText("XPA16014"), new NonLocalizablePanelValue(new String(senseData, 4, 1))), new CaptionValuePairing(new BaseMessageText("XPA16016"), new NonLocalizablePanelValue(new String(senseData, 5, 1))), new CaptionValuePairing(new BaseMessageText("XPA16018"), new NonLocalizablePanelValue(new String(senseData, 6, 1))), new CaptionValuePairing(new BaseMessageText("XPA16020"), new NonLocalizablePanelValue(new String(senseData, 7, 8))), new CaptionValuePairing(new BaseMessageText("XPA16022"), new NonLocalizablePanelValue(new String(senseData, 15, 5))), new CaptionValuePairing(new BaseMessageText("XPA16023"), new NonLocalizablePanelValue(new String(senseData, 20, 2))), new CaptionValuePairing(new BaseMessageText("XPA16024"), new NonLocalizablePanelValue(new String(senseData, 22, 2))), new CaptionValuePairing(new BaseMessageText("XPA16025"), new NonLocalizablePanelValue(new String(senseData, 24, 1))), new CaptionValuePairing(new BaseMessageText("XPA16026"), new NonLocalizablePanelValue(new String(senseData, 25, 1))), new CaptionValuePairing(new BaseMessageText("XPA16027"), new NonLocalizablePanelValue(new String(senseData, 26, 2))), new CaptionValuePairing(new BaseMessageText("XPA16029"), new NonLocalizablePanelValue(new String(senseData, 28, 2))), new CaptionValuePairing(new BaseMessageText("XPA16030"), new NonLocalizablePanelValue(new String(senseData, 29, 2))), new CaptionValuePairing(new BaseMessageText("XPA16031"), new NonLocalizablePanelValue(new String(senseData, 31, 1)))});
        return entries;
    }

    private static String formatByte0(byte data) {
        boolean previous = false;
        StringBuffer sData = new StringBuffer();
        if ((data & 0x80) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16032")).append("  ,  ");
        }
        if ((data & 0x40) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16033")).append("  ,  ");
        }
        if ((data & 0x20) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16037")).append("  ,  ");
        }
        if ((data & 0x10) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16034")).append("  ,  ");
        }
        if ((data & 8) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16037")).append("  ,  ");
        }
        if ((data & 4) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16037")).append("  ,  ");
        }
        if ((data & 2) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16037")).append("  ,  ");
        }
        if ((data & 1) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16036")).append("  ,  ");
        }
        return sData.toString();
    }

    private static String formatByte1(byte data) {
        boolean previous = false;
        StringBuffer sData = new StringBuffer();
        if ((data & 0x80) != 0) {
            sData.append(new BaseMessageText("XPA16038"));
            previous = true;
        }
        if ((data & 0x40) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16039"));
            previous = true;
        }
        if ((data & 0x20) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16040"));
            previous = true;
        }
        if ((data & 0x10) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16041"));
            previous = true;
        }
        if ((data & 8) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16042"));
            previous = true;
        }
        if ((data & 4) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16043"));
            previous = true;
        }
        if ((data & 2) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16044"));
            previous = true;
        }
        if ((data & 1) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16045"));
            previous = true;
        }
        return sData.toString();
    }

    private static String formatByte2(byte data) {
        boolean previous = false;
        StringBuffer sData = new StringBuffer();
        if ((data & 0x80) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA160346"));
            previous = true;
        }
        if ((data & 0x40) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16037"));
            previous = true;
        }
        if ((data & 0x20) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16047"));
            previous = true;
        }
        if ((data & 0x10) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16048"));
            previous = true;
        }
        if ((data & 8) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16037"));
            previous = true;
        }
        if ((data & 4) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16045"));
            previous = true;
        }
        if ((data & 2) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16037"));
            previous = true;
        }
        if ((data & 1) != 0) {
            if (previous) {
                sData.append("  ,  ");
            }
            sData.append(new BaseMessageText("XPA16037"));
            previous = true;
        }
        return sData.toString();
    }
}

